# -*- coding: UTF-8 -*-

# 2022-04-19

import os, time
import xbmc, xbmcgui, xbmcaddon
from lib.utils import  profilePath, LOGINFO, busy, idle, check_del, reload_profile

Addon = xbmcaddon.Addon('service.xS.versioncheck')
AddonID = Addon.getAddonInfo('id')
AddonName = Addon.getAddonInfo('name')

currentTime = int(time.time())

def update():
    from lib.updateManager import Update
    INSTALL_CONTROL = os.path.join(profilePath, "addons_installed")
    try:
        username = Addon.getSetting('service.username')
        token = Addon.getSetting('service.git_token')
        plugin_id = AddonID
        branch = 'master'
        status = Update(username, plugin_id, branch, token, True)
        if status == True and os.path.isfile(INSTALL_CONTROL)== True:
            os.remove(INSTALL_CONTROL)
        return status
    except Exception as e:
            xbmc.log('Exception Raised: %s' % str(e), LOGINFO)
            pass

if __name__ == '__main__':
    PROFIL_RELOAD = os.path.join(profilePath, "profil_reload")
    if os.path.isfile(PROFIL_RELOAD) == False:
        if Addon.getSetting('service.git_token') != '' and Addon.getSetting('service.username') != '':
            busy()
            status = ''
            status = update()
            if status == 'auth-error':
                xbmcgui.Dialog().ok(AddonName, 'Fehler beim Update von  [COLOR red]' + AddonID + '[/COLOR]\nUpdate-Key abgelaufen oder Username ungültig! \nAutoUpdate wird deaktiviert!')
                Addon.setSetting(id='service.autoupdate', value='false')
            elif status == False:
                xbmcgui.Dialog().ok(AddonName, 'Fehler beim Update von [COLOR red]' + AddonID + '[/COLOR]\n ?? Problem Internet ??')

            elif status == True:
                idle()
                xbmc.sleep(200)
                reload_profile(False)

        else:
            xbmcgui.Dialog().ok(AddonName, '[COLOR red]' + AddonID + '[/COLOR]\nKeine vollständigen Zugangsdaten! \nAutoUpdate wird deaktiviert!')
            Addon.setSetting(id='service.autoupdate', value='false')

        idle()

    else:
        os.remove(PROFIL_RELOAD)
        if Addon.getSetting('update.enforceUpdate') == 'true': Addon.setSetting('update.enforceUpdate', 'false')
        #utils.infoDialog("Auto Update abgeschlossen", sound=False, icon='INFO', time=3000)

