# -*- coding: UTF-8 -*-

import os, sys, time, hashlib
import xbmc, xbmcgui, xbmcaddon, xbmcvfs

Addon = xbmcaddon.Addon()
AddonName = Addon.getAddonInfo('name')

if sys.version_info[0] == 2:
    from xbmc import LOGNOTICE as LOGINFO
    from xbmc import translatePath
    AddonPath = translatePath(Addon.getAddonInfo('path')).decode('utf-8')
    profilePath = translatePath(Addon.getAddonInfo('profile')).decode('utf-8')
    thumbnails = translatePath('special://thumbnails').decode('utf-8')
    dbpath = translatePath("special://database/Textures13.db").decode('utf-8')
    dir_packages = translatePath('special://home/addons/packages/').decode('utf-8')
else:
    from xbmc import LOGINFO
    from xbmcvfs import translatePath
    AddonPath = translatePath(Addon.getAddonInfo('path'))
    profilePath = translatePath(Addon.getAddonInfo('profile'))
    thumbnails = translatePath('special://thumbnails')
    dbpath = translatePath("special://database/Textures13.db")
    dir_packages = translatePath('special://home/addons/packages/')

def infoDialog(message, heading=AddonName, icon='', time=5000, sound=False):
    if icon == '': icon = Addon.getAddonInfo('icon')
    elif icon == 'INFO': icon = xbmcgui.NOTIFICATION_INFO
    elif icon == 'WARNING': icon = xbmcgui.NOTIFICATION_WARNING
    elif icon == 'ERROR': icon = xbmcgui.NOTIFICATION_ERROR
    xbmcgui.Dialog().notification(heading, message, icon, time, sound=sound)

def reload_profile(makefile=True):
    if makefile:
        PROFIL_RELOAD = os.path.join(profilePath, "profil_reload")
        open(PROFIL_RELOAD, "w+").write('Profil reload')
        xbmc.sleep(80)
    profil=xbmc.getInfoLabel('System.ProfileName')
    if profil: xbmc.executebuiltin('LoadProfile('+profil+',prompt)')

def check_del():
    dayfornextcheck = Addon.getSettingInt('utils.dayfornextcheck')
    enforceRefresh = Addon.getSetting('enforceRefresh')
    
    try:
        if enforceRefresh == 'true':
            Addon.setSetting('utils.old_dayfornextcheck', str(dayfornextcheck))
            #Addon.setSetting('enforceRefresh', 'false')
            _del_thumbnails(dayfornextcheck)
            _del_more()
            Addon.setSetting('enforceRefresh', 'false')
            return

        old_dayfornextcheck = int(Addon.getSetting('utils.old_dayfornextcheck'))
        if dayfornextcheck != old_dayfornextcheck:
            Addon.setSetting('utils.old_dayfornextcheck', str(dayfornextcheck))
            _del_thumbnails(dayfornextcheck)
            return

        nextcheck = int(Addon.getSetting('utils.nextcheck'))
        currentTime = int(time.time())
        if currentTime >= nextcheck:
            _del_thumbnails(dayfornextcheck)
            _del_more()
            return

    except:
        Addon.setSetting('utils.old_dayfornextcheck', str(dayfornextcheck))
        _del_thumbnails(dayfornextcheck)
        _del_more()


def _del_thumbnails(dayfornextcheck): #    """kodi texture cache / thumbnails - del images"""
    import sqlite3
    connection = sqlite3.connect(dbpath, timeout=30, isolation_level=None)
    try:
        cache_images = connection.execute('SELECT cachedurl FROM texture').fetchall()
        if cache_images:
            for cache_image in cache_images:
                if xbmcvfs.exists(thumbnails + cache_image[0]):
                    xbmcvfs.delete(thumbnails + cache_image[0])

        connection.execute('DELETE FROM texture')
        connection.close()
        nextcheck = str(int(time.time()) + 60*60*24*dayfornextcheck)

        Addon.setSetting(id='utils.nextcheck', value=nextcheck) # sek min stunden, tage

        infoDialog("Thumbnails in Cache & Filesystem gelöscht", sound=False, icon='INFO', time=3000)
    except Exception as exc:
        pass
        #log_exception(__name__, exc)
    finally:
        del connection

def _del_more(): # addons\packages
    dirs,files = xbmcvfs.listdir(dir_packages)
    for file in files: xbmcvfs.delete(dir_packages + file)

def getKodiVersion():
    return xbmc.getInfoLabel("System.BuildVersion").split(".")[0]

def busy():
    if int(getKodiVersion()) >= 18:
        return xbmc.executebuiltin('ActivateWindow(busydialognocancel)')
    else:
        return xbmc.executebuiltin('ActivateWindow(busydialog)')

def idle():
    if int(getKodiVersion()) >= 18:
        return xbmc.executebuiltin('Dialog.Close(busydialognocancel)')
    else:
        return xbmc.executebuiltin('Dialog.Close(busydialog)')

def md5(fname):
    hash_md5 = hashlib.md5()
    with open(fname, "rb") as f:
        for chunk in iter(lambda: f.read(4096), b""):
            hash_md5.update(chunk)
    return hash_md5.hexdigest()

