# -*- coding: utf-8 -*-
# Python 3

import xbmc
from resources.lib.gui.gui import cGui
from resources.lib.config import cConfig
from xbmc import LOGINFO as LOGNOTICE, LOGERROR, log

class XstreamPlayer(xbmc.Player):
    def __init__(self, *args, **kwargs):
        xbmc.Player.__init__(self, *args, **kwargs)
        self.streamFinished = False
        self.streamSuccess = True
        self.playedTime = 0
        self.totalTime = 999999
        self.from_global_search = False  # Track if started from Global Search
        log(cConfig().getLocalizedString(30166) + ' -> [player]: player instance created', LOGNOTICE)

    def onPlayBackStarted(self):
        log(cConfig().getLocalizedString(30166) + ' -> [player]: starting Playback', LOGNOTICE)
        try:
            self.totalTime = self.getTotalTime()
        except:
            self.totalTime = 999999

        # Detect if playback started from Search or Global Search
        try:
            path = xbmc.getInfoLabel('Container.FolderPath')
            if path:
                low = path.lower()
                # Erweiterte Prüfung auf Suche
                keywords = [
                    'function=globalsearch',
                    'site=globalsearch',
                    'function=searchalter',
                    'function=searchtmdb',
                    'function=showsearch',  # Normale Suche
                    'function=_search',  # Interne Suchfunktion
                    'search'  # Allgemeiner Suchbegriff in URL
                ]
                if any(kw in low for kw in keywords):
                    self.from_global_search = True
                    log(cConfig().getLocalizedString(30166) + ' -> [player]: Detected Search context', LOGNOTICE)
        except:
            pass

    def onPlayBackStopped(self):
        log(cConfig().getLocalizedString(30166) + ' -> [player]: Playback stopped', LOGNOTICE)
        if self.playedTime == 0 and self.totalTime == 999999:
            self.streamSuccess = False
            log(cConfig().getLocalizedString(30166) + ' -> [player]: Kodi failed to open stream', LOGERROR)
        self.streamFinished = True

        # After playback ends, return to the appropriate screen
        if self.from_global_search:
            try:
                xbmc.sleep(1500)  # Add a short delay to allow UI to settle after playback stop

                # Intelligente Navigation zurück zur letzten Seite
                # Statt direkt zum Hauptmenü zurückzukehren, versuchen wir zur vorherigen Seite zurückzukehren
                previous_window = xbmc.getInfoLabel('Container.FolderPath')
                if 'globalsearch' in previous_window.lower():
                    # Bei globaler Suche zum Hauptmenü zurückkehren
                    xbmc.executebuiltin('ReplaceWindow(Videos,plugin://plugin.video.xstream/)')
                else:
                    # Bei normaler Suche einfach zurück navigieren
                    xbmc.executebuiltin('Action(Back)')
                    xbmc.executebuiltin('ReplaceWindow(Videos,plugin://plugin.video.xstream/)')

                log('xStream -> [player]: Returning after Search', LOGNOTICE)
            except Exception as e:
                log('xStream -> [player]: Failed to return after search: %s' % str(e), LOGERROR)

    def onPlayBackEnded(self):
        log(cConfig().getLocalizedString(30166) + ' -> [player]: Playback completed', LOGNOTICE)
        self.onPlayBackStopped()


class cPlayer:
    def clearPlayList(self):
        oPlaylist = self.__getPlayList()
        oPlaylist.clear()

    def __getPlayList(self):
        return xbmc.PlayList(xbmc.PLAYLIST_VIDEO)

    def addItemToPlaylist(self, oGuiElement):
        oListItem = cGui().createListItem(oGuiElement)
        self.__addItemToPlaylist(oGuiElement, oListItem)

    def __addItemToPlaylist(self, oGuiElement, oListItem):
        oPlaylist = self.__getPlayList()
        oPlaylist.add(oGuiElement.getMediaUrl(), oListItem)

    def startPlayer(self):
        log(cConfig().getLocalizedString(30166) + ' -> [player]: start player', LOGNOTICE)
        xbmcPlayer = XstreamPlayer()
        monitor = xbmc.Monitor()
        while (not monitor.abortRequested()) & (not xbmcPlayer.streamFinished):
            if xbmcPlayer.isPlayingVideo():
                xbmcPlayer.playedTime = xbmcPlayer.getTime()
            monitor.waitForAbort(10)
        return xbmcPlayer.streamSuccess