

# kinoger

import re, ast
from resources.lib.control import  getSetting
from resources.lib.requestHandler import cRequestHandler
from scrapers.modules import dom_parser, cleantitle
# from scrapers.modules.tools import cParser, cUtil
from resources.lib import log_utils
from resources.lib.utils import isBlockedHoster

SITE_IDENTIFIER = 'kinoger'
SITE_DOMAIN = 'kinoger.com'
SITE_NAME = SITE_IDENTIFIER.upper()

class source:
    def __init__(self):
        self.priority = 1
        self.language = ['de']
        self.domain = getSetting('provider.' + SITE_IDENTIFIER + '.domain', SITE_DOMAIN)
        self.base_link = 'https://' + self.domain
        self.search = self.base_link + '/index.php?do=search&subaction=search&search_start=1&full_search=0&result_from=1&titleonly=3&story=%s'
        self.sources = []

    def run(self, titles, year, season=0, episode=0, imdb='', hostDict=None):
        sources = []
        items = []
        url = ''
        try:
            t = [cleantitle.get(i) for i in titles  if i]
            years = [str(year), str(year + 1)] if season == 0 else ['']
            for title in titles:
                try:
                    sUrl = self.search % title
                    oRequest = cRequestHandler(sUrl)
                    oRequest.removeBreakLines(False)
                    oRequest.removeNewLines(False)
                    oRequest.cacheTime = 60 * 60 * 12
                    sHtmlContent = oRequest.request()

                    search_results = dom_parser.parse_dom(sHtmlContent, 'div', attrs={'class': 'title'})
                    search_results = dom_parser.parse_dom(search_results, 'a')
                    search_results = [(i.attrs['href'], i.content) for i in search_results]
                    search_results = [(i[0], re.findall('(.*?)\((\d+)', i[1])[0]) for i in search_results]

                    if season > 0:
                        for x in range(0, len(search_results)):
                            title = cleantitle.get(search_results[x][1][0])
                            if 'staffel' in title and any(k in title for k in t):
                                url = search_results[x][0]
                    else:
                        for x in range(0, len(search_results)):
                            title = cleantitle.get(search_results[x][1][0])
                            if any(k in title for k in t) and search_results[x][1][1] in years:
                                url = search_results[x][0]
                                break
                    if url != '': break
                except:
                    pass

            if url == '': return sources

            oRequest = cRequestHandler(url)
            oRequest.cacheTime = 60 * 60 * 12
            sHtmlContent = oRequest.request()
            quali = re.findall('title="Stream.(.+?)"', sHtmlContent)
            links = re.findall('.show.+?,(\[\[.+?\]\])', sHtmlContent)
            if len(links) == 0: return sources

            if season > 0 and episode > 0:
                season = season - 1
                episode = episode - 1

            for i in range(0, len(links)):
                direct = True
                pw = ast.literal_eval(links[i])
                url = (pw[season][episode]).strip()
                isBlocked, hoster, url, prioHoster = isBlockedHoster(url, isResolve=False)
                if isBlocked: direct = False
                quality = quali[i]
                if quality == '': quality = 'SD'
                if quality == 'HD': quality = '720p'
                if quality == 'HD+': quality = '1080p'
                items.append({'source': hoster, 'quality': quality, 'url': url, 'direct': direct, 'prioHoster': prioHoster})

            # headers = '&Accept-Language=de%2Cen-US%3Bq%3D0.7%2Cen%3Bq%3D0.3&Accept=%2A%2F%2A&User-Agent=Mozilla%2F5.0+%28Windows+NT+10.0%3B+Win64%3B+x64%3B+rv%3A99.0%29+Gecko%2F20100101+Firefox%2F99.0'
            for item in items:
                try:
                        isBlocked, hoster, url, prioHoster = isBlockedHoster(item['url'], isResolve=True)
                        if isBlocked: continue
                        sources.append({'source': item['source'], 'quality': item['quality'], 'language': 'de','url': url, 'direct': item['direct'], 'prioHoster': item['prioHoster']})
                except:
                    continue


            if len(sources) == 0:
                log_utils.log('Kinoger: kein Provider - %s ' % titles[0], log_utils.LOGINFO)
            else:
                for source in sources:
                    if source not in self.sources: self.sources.append(source)
                return self.sources
        except:
            return sources


    def resolve(self, url):
        try:
            return url
        except:
            return


    # def _quality(self, q): # Kinoger.be Quality
    #     hl = q.split('x')
    #     h = int(hl[0])
    #     l = int(hl[1])
    #     if h >= 1920: return '1080p'
    #     elif l >= 720 or h >= 1080: return '720p'
    #     else: return 'SD'